/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.justverticalslabs.recipes.crafting.recipes;

import crystalspider.justverticalslabs.JustVerticalSlabsLoader;
import crystalspider.justverticalslabs.recipes.crafting.VerticalSlabCraftingRecipe;
import crystalspider.justverticalslabs.utils.VerticalSlabUtils;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SlabToBlockCraftingRecipe
extends VerticalSlabCraftingRecipe {
    public static final String ID = "slab_to_block_crafting_recipe";
    private static final ResourceLocation RESOURCE_LOCATION = VerticalSlabUtils.getResourceLocation("slab_to_block_crafting_recipe");

    public SlabToBlockCraftingRecipe() {
        super(1, 2);
    }

    @Override
    @Nonnull
    public ItemStack assemble(@Nonnull ItemStack matchedItem) {
        return ((Item)VerticalSlabUtils.MapsManager.slabMap.get((Object)matchedItem.m_41720_())).m_7968_();
    }

    public ResourceLocation m_6423_() {
        return RESOURCE_LOCATION;
    }

    public Serializer getSerializer() {
        return (Serializer)JustVerticalSlabsLoader.SLAB_TO_BLOCK_CRAFTING_RECIPE_SERIALIZER.get();
    }

    @Override
    protected Integer getMatchIndex(CraftingContainer craftingContainer) {
        boolean correctPattern = true;
        Integer matchIndex = null;
        Integer containerWidth = craftingContainer.m_39347_();
        for (int h = 0; h < containerWidth && correctPattern; ++h) {
            for (int w = 0; w < craftingContainer.m_39346_() && correctPattern; ++w) {
                int index = w + h * containerWidth;
                ItemStack itemStack1 = craftingContainer.m_8020_(index);
                if (itemStack1.m_41619_()) continue;
                Item item = itemStack1.m_41720_();
                if (VerticalSlabUtils.MapsManager.slabMap.containsKey((Object)item)) {
                    ItemStack itemStack2 = craftingContainer.m_8020_(index + containerWidth);
                    if (itemStack2.m_150930_(item)) {
                        if (matchIndex == null) {
                            matchIndex = index;
                            continue;
                        }
                        matchIndex = null;
                        correctPattern = false;
                        continue;
                    }
                    if (matchIndex != null && matchIndex == index - containerWidth) continue;
                    matchIndex = null;
                    correctPattern = false;
                    continue;
                }
                matchIndex = null;
                correctPattern = false;
            }
        }
        return matchIndex;
    }

    public static class Serializer
    extends VerticalSlabCraftingRecipe.Serializer<SlabToBlockCraftingRecipe> {
        public static final String ID = "slab_to_block_crafting_recipe_serializer";
        public static final ResourceLocation RESOURCE_LOCATION = VerticalSlabUtils.getResourceLocation("slab_to_block_crafting_recipe_serializer");

        public Serializer() {
            super(SlabToBlockCraftingRecipe::new);
        }
    }
}

